package gov.cms.grouper.snf.model.table;

import gov.cms.grouper.snf.lego.CsvBuilder;
import gov.cms.grouper.snf.lego.SnfUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiConsumer;

public class ClinicalCategoryMappingRow extends BasicRow {

  public static final String SLP_Acute_Neurologic = "Acute Neurologic";

  private String pdsClinicalCategory;
  private String ptOtClinicalCategory;
  private String slpClinicalCategory;

  private ClinicalCategoryMappingRow() {}

  public ClinicalCategoryMappingRow(String pdsClinicalCategory, String ptOtClinicalCategory,
      String slpClinicalCategory) {
    super();
    this.pdsClinicalCategory = pdsClinicalCategory;
    this.ptOtClinicalCategory = ptOtClinicalCategory;
    this.slpClinicalCategory = slpClinicalCategory;
  }

  public String getPdsClinicalCategory() {
    return this.pdsClinicalCategory;
  }

  public void setPdsClinicalCategory(String pdsClinicalCategory) {
    this.pdsClinicalCategory = pdsClinicalCategory;
  }

  public String getPtOtClinicalCategory() {
    return this.ptOtClinicalCategory;
  }

  public void setPtOtClinicalCategory(String ptOtClinicalCategory) {
    this.ptOtClinicalCategory = ptOtClinicalCategory;
  }

  public String getSlpClinicalCategory() {
    return this.slpClinicalCategory;
  }

  public void setSlpClinicalCategory(String slpClinicalCategory) {
    this.slpClinicalCategory = slpClinicalCategory;
  }

  @Override
  public int hashCode() {
    final int prime = 31;
    int result = 1;
    result = super.getHashCode(result, prime);
    result = prime * result
        + ((this.pdsClinicalCategory == null) ? 0 : this.pdsClinicalCategory.hashCode());
    result = prime * result
        + ((this.ptOtClinicalCategory == null) ? 0 : this.ptOtClinicalCategory.hashCode());
    result = prime * result
        + ((this.slpClinicalCategory == null) ? 0 : this.slpClinicalCategory.hashCode());
    return result;
  }

  @Override
  public boolean equals(Object obj) {
    if (this == obj) {
      return true;
    }
    if (obj == null) {
      return false;
    }
    if (this.getClass() != obj.getClass()) {
      return false;
    }
    ClinicalCategoryMappingRow other = (ClinicalCategoryMappingRow) obj;
    if (super.equals(other) == false) {
      return false;
    }
    if (this.pdsClinicalCategory == null) {
      if (other.pdsClinicalCategory != null) {
        return false;
      }
    } else if (!this.pdsClinicalCategory.equals(other.pdsClinicalCategory)) {
      return false;
    }
    if (this.ptOtClinicalCategory == null) {
      if (other.ptOtClinicalCategory != null) {
        return false;
      }
    } else if (!this.ptOtClinicalCategory.equals(other.ptOtClinicalCategory)) {
      return false;
    }
    if (this.slpClinicalCategory == null) {
      if (other.slpClinicalCategory != null) {
        return false;
      }
    } else if (!this.slpClinicalCategory.equals(other.slpClinicalCategory)) {
      return false;
    }
    return true;
  }

  public static class Builder extends CsvBuilder<ClinicalCategoryMappingRow> {
    private static final BiConsumer<ClinicalCategoryMappingRow, String> pdsClinicalCategory =
        (val, str) -> val.pdsClinicalCategory = SnfUtils.clean(str);
    private static final BiConsumer<ClinicalCategoryMappingRow, String> ptOtClinicalCategory =
        (val, str) -> val.ptOtClinicalCategory = SnfUtils.clean(str);
    private static final BiConsumer<ClinicalCategoryMappingRow, String> slpClinicalCategory =
        (val, str) -> val.slpClinicalCategory = SnfUtils.clean(str);

    private static final Builder singleton = new Builder();

    private Builder() {
      super(ClinicalCategoryMappingRow::new, Builder.initCsvMapping());
    }

    public static Map<Integer, BiConsumer<ClinicalCategoryMappingRow, String>> initCsvMapping() {
      Map<Integer, BiConsumer<ClinicalCategoryMappingRow, String>> result = new HashMap<>();
      result.put(0, Builder.pdsClinicalCategory);
      result.put(1, BasicRow.getLowVersionParser());
      result.put(2, BasicRow.getHighVersionParser());
      result.put(3, Builder.ptOtClinicalCategory);
      result.put(4, Builder.slpClinicalCategory);

      return Collections.unmodifiableMap(result);
    }

    public static Builder of() {
      return Builder.singleton;
    }

  }

}
